/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.api.VWApplicationSpace;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCreateLiveWOResult;
import filenet.vw.api.VWDBExecuteConnection;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWParticipantList;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWQueueStats;
import filenet.vw.api.VWReturnStackElement;
import filenet.vw.api.VWRole;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRosterStats;
import filenet.vw.api.VWSecurityDomain;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWTransferResult;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.RetryManager;
import filenet.vw.base.VWIMS;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.IPECommands;
import filenet.vw.server.IVWCommand;
import filenet.vw.server.IVWRouter;
import filenet.vw.server.InternalVWWorkBasket;
import filenet.vw.server.VWCapsule;
import filenet.vw.server.VWCommandResult;
import filenet.vw.server.VWConfigInfo;
import filenet.vw.server.VWConfigResult;
import filenet.vw.server.VWEnvironmentData;
import filenet.vw.server.VWEnvironmentDataQueryResults;
import filenet.vw.server.VWField;
import filenet.vw.server.VWFieldUtility;
import filenet.vw.server.VWInjectInfo;
import filenet.vw.server.VWLogonCredentials;
import filenet.vw.server.VWLogonHandle;
import filenet.vw.server.VWLogonResult;
import filenet.vw.server.VWNoOnlineClassesException;
import filenet.vw.server.VWOpNotAllowedException;
import filenet.vw.server.VWQueryResults;
import filenet.vw.server.VWSecurityQueryResults;
import filenet.vw.server.VWServerCommand;
import filenet.vw.server.VWStaleLogonException;
import filenet.vw.server.VWSystemConfigInfo;
import filenet.vw.server.VWSystemWideInfo;
import filenet.vw.server.VWViewDoesNotExistException;
import filenet.vw.server.VWViewIdCommand;
import filenet.vw.server.VWWorkObjectID;
import filenet.vw.server.VWWorkRecord;
import filenet.vw.soap.VWSOAPCommand;
import filenet.vw.soap.VWSOAPRouterURL;
import filenet.vw.soap.util.VWSOAPUtils;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;

public class VWCommandSession
implements IPECommands,
Serializable {
    private static final long serialVersionUID = 119301L;
    public static final long RPC_VERSION_MASK = 65535L;
    public static final long RPC_LVL_0 = 0L;
    public static final long RPC_LVL_1 = 1L;
    public static final long RPC_FLAG_MASK = -65536L;
    public static final long RPC_FLAG_BASE = 65536L;
    public static final long RPC_WITH_DOMAIN = 65536L;
    public static final long RPC_RESOLVE_USER_ID = 131072L;
    protected VWLogonHandle[] logonHandles = null;
    protected int[] serverIds;
    protected int serverCount = 0;
    protected VWLogonCredentials logonCreds = null;
    protected int isolatedRegion = -1;
    private static Logger logger = Logger.getLogger("filenet.vw.server");
    private String m_className = "VWCommandSession";
    protected transient IVWCommand commandInterface = null;
    protected VWLogonHandle logonHandle = null;
    protected int serverId = -1;
    protected VWCommandSession parentSession = null;
    protected Hashtable childSessions = null;
    protected String theRouterURL = null;
    protected String theDestination = null;
    protected static final int MAX_SERVERS = 100;
    private static final VWException NOT_IMPLEMENTED = new VWException("server.vwCommandSession.notImplemented", "NOT IMPLEMENTED");
    protected static long RPC_TIMEOUT;
    protected static final String RPC_TIMEOUT_PROPERTY = "filenet.vw.api.rpc.timeout";
    private String m_serviceDestination;

    public static String _get_FILE_DATE() {
        return "$Date:   11 Sep 2008 13:31:08  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.238  $";
    }

    public static void SetTimeout(long timeout) {
        if (timeout > 0L) {
            RPC_TIMEOUT = timeout;
        }
    }

    protected VWCommandSession() {
    }

    protected VWCommandSession(VWLogonCredentials creds, String routerURL) throws VWException {
        String m_method = "ctor1 " + routerURL + ", name=" + creds.getUserName();
        logger.entering(this.m_className, m_method);
        this.logonCreds = creds;
        try {
            this.init(routerURL, null);
            logger.finest(this.m_className, m_method, "ir=" + this.logonCreds.getIsolatedRegion());
        }
        catch (Exception e) {
            VWException vwe = new VWException("vw.server.VWCommandSessionServiceRouterNotFound", "{0} {1}", this.theRouterURL, e.getMessage());
            vwe.setCause(e);
            throw vwe;
        }
        logger.exiting(this.m_className, m_method);
    }

    protected VWCommandSession(String token, String routerURL) throws VWException {
        String m_method = "ctor2 " + routerURL;
        logger.entering(this.m_className, m_method);
        this.init(routerURL, token);
        logger.exiting(this.m_className, m_method);
    }

    protected VWCommandSession(String token, VWSOAPRouterURL soapURL) throws VWException {
        String m_method = "ctor3 soapURL=" + soapURL.toString();
        logger.entering(this.m_className, m_method);
        try {
            this.commandInterface = new VWSOAPCommand(soapURL, token);
            this.theRouterURL = soapURL.toString();
            this.logonCreds = new VWLogonCredentials(null, null);
            this.logon(null);
            if (this.logonCreds != null) {
                this.isolatedRegion = this.logonCreds.getIsolatedRegion();
            }
        }
        catch (Exception e) {
            VWException vwe = new VWException("vw.api.VWCommandSessionRouterNull", "Failed to construct session {0}", e.getMessage());
            vwe.setCause(e);
            throw vwe;
        }
        logger.exiting(this.m_className, m_method);
    }

    protected void init(String routerURL, String token) throws VWException {
        String m_method = "init:" + routerURL;
        if (routerURL == null || routerURL.length() == 0) {
            throw new VWException("vw.api.VWCommandSessionRouterNull", "Router URL is null.  Need to enter router url.");
        }
        boolean forTrident = false;
        int tridentX = routerURL.indexOf(".trident");
        if (tridentX > -1) {
            forTrident = true;
            routerURL = routerURL.substring(1, tridentX);
        }
        String url = routerURL;
        try {
            if (!url.toUpperCase(Locale.ENGLISH).startsWith("RMI://")) {
                if (!url.startsWith("//")) {
                    int inx = url.indexOf("/");
                    if (inx == -1) {
                        InetAddress myAddress = InetAddress.getLocalHost();
                        String myHostName = myAddress.getHostName();
                        url = myHostName + "/" + url;
                    }
                    url = "//" + url;
                }
                url = "rmi:" + url;
            }
            String fullURL = "";
            StringTokenizer stmp = new StringTokenizer(url, "/");
            while (stmp.hasMoreTokens()) {
                String tempString = stmp.nextToken();
                fullURL = stmp.hasMoreTokens() ? (tempString.toUpperCase(Locale.ENGLISH).startsWith("RMI:") ? tempString + "/" : fullURL + "/" + tempString) : (!tempString.startsWith("FileNET.VW.VWRouter.") ? fullURL + "/FileNET.VW.VWRouter." + tempString : fullURL + "/" + tempString);
                logger.finest(this.m_className, m_method, "FullURL: " + fullURL);
            }
            this.theRouterURL = fullURL;
            RetryManager retry = new RetryManager(RPC_TIMEOUT);
            RemoteException lastException = null;
            do {
                try {
                    this.commandInterface = (IVWCommand)Naming.lookup(fullURL);
                    if (token != null) {
                        if (forTrident) {
                            this.logonCreds = new VWLogonCredentials("", token);
                        } else {
                            logger.finest(this.m_className, m_method, "decoding token");
                            try {
                                this.logonCreds = ((IVWRouter)((Object)this.commandInterface)).getAuthorization(token);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (this.logonCreds == null) {
                                logger.finest(this.m_className, m_method, "TRY OUR WAY AHA.");
                                try {
                                    this.logonCreds = this.decodeToken(token);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (this.logonCreds != null) {
                                logger.finest(this.m_className, m_method, "token decoded user=" + this.logonCreds.getUserName());
                            }
                        }
                    }
                    this.isolatedRegion = ((IVWRouter)((Object)this.commandInterface)).getIsolatedRegion();
                    if (this.logonCreds == null || this.logonCreds.getUserName() == null) {
                        this.getUnifiedLogonCredentials(this.isolatedRegion);
                    }
                    this.logonCreds.setIsolatedRegion(this.isolatedRegion);
                    retry.stop();
                }
                catch (RemoteException re) {
                    logger.throwing(this.m_className, m_method, re);
                    lastException = re;
                }
            } while (retry.again());
            if (this.commandInterface == null) {
                throw new VWException("vw.server.VWCommandSessionServiceRouterLookupFail", "Look up failed. Router URL: {0}, message: {1}", url, lastException != null ? ((Throwable)lastException).getMessage() : "No Error");
            }
        }
        catch (VWException vwEx) {
            logger.throwing(this.m_className, m_method, vwEx);
            throw vwEx;
        }
        catch (Exception e) {
            logger.throwing(this.m_className, m_method, e);
            VWException vwe = new VWException("vw.server.VWCommandSessionServiceRouterNotFound", "Router not found. Router URL: {0}, message: {1}", url, e.getMessage());
            vwe.setCause(e);
            throw vwe;
        }
    }

    public void reinit() throws VWException {
        try {
            if (this.parentSession == null) {
                this.init(this.theRouterURL, null);
            } else {
                this.parentSession.reinit();
                this.logonCreds = this.parentSession.logonCreds;
                IVWRouter router = this.parentSession.getRouter();
                if (router == null) {
                    throw new VWException("vw.server.VWCommandSessionCouldNotFindRouterInParent", "Could not get Router from parent session.");
                }
                this.getDestination(router, this.theDestination);
                this.parentSession.updateChildSession(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void getUnifiedLogonCredentials(int isolatedRegion) throws VWException {
        String m_method = "getUnifiedLogonCredentials";
        try {
            String securityClassName = "filenet.vw.ntutil.security.NTSecurity";
            String getCurrentThreadTokenMethodName = "getCurrentThreadToken";
            final int thisIsolatedRegion = isolatedRegion;
            logger.finest(this.m_className, "getUnifiedLogonCredentials", "Loading filenet.vw.ntutil.security.NTSecurity");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class<?> NTSecurityClass = Class.forName("filenet.vw.ntutil.security.NTSecurity");
                        Method getCurrentThreadTokenMethod = NTSecurityClass.getDeclaredMethod("getCurrentThreadToken", null);
                        logger.finest(VWCommandSession.this.m_className, "getUnifiedLogonCredentials", "Invoking getCurrentThreadToken");
                        Object ntSecurityObj = NTSecurityClass.newInstance();
                        Object ntSecurityTokenObj = getCurrentThreadTokenMethod.invoke(ntSecurityObj, null);
                        String username = ntSecurityTokenObj.toString().toUpperCase(Locale.ENGLISH);
                        String pwd = VWIMS.getToken(username);
                        logger.finest(VWCommandSession.this.m_className, "getUnifiedLogonCredentials", "username=" + username);
                        if (pwd != null && username != null) {
                            VWCommandSession.this.logonCreds = new VWLogonCredentials(username, pwd, thisIsolatedRegion);
                        }
                        return null;
                    }
                    catch (Throwable t) {
                        logger.throwing(VWCommandSession.this.m_className, "getUnifiedLogonCredentials", t);
                        return null;
                    }
                }
            });
        }
        catch (Exception ex) {
            logger.throwing(this.m_className, "getUnifiedLogonCredentials", ex);
            throw new VWException("vw.server.VWCommandSessionServiceCannotGetUserThread.1", "Cannot get user name. {0}", ex.getMessage());
        }
        if (this.logonCreds == null) {
            throw new VWException("vw.server.VWCommandSessionServiceCannotGetUserThread", "Cannot get user name internally. Try user name and password");
        }
    }

    public VWCommandSession(VWCommandSession aParentSession, String destination) throws VWException {
        String m_method = "ctor(child)";
        logger.entering(this.m_className, m_method);
        this.parentSession = aParentSession;
        this.logonCreds = this.parentSession.logonCreds;
        IVWRouter router = this.parentSession.getRouter();
        if (router == null) {
            throw new VWException("vw.server.VWCommandSessionCouldNotFindRouterInParent", "Could not get Router from parent session.");
        }
        this.theDestination = destination;
        this.getDestination(router, destination);
        this.parentSession.updateChildSession(this);
        logger.exiting(this.m_className, m_method);
    }

    public int getIsolatedRegion() {
        return this.isolatedRegion;
    }

    public String getServiceDestination() {
        return this.m_serviceDestination;
    }

    public void setServiceDestination(String s) {
        this.m_serviceDestination = s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void getDestination(IVWRouter router, String destination) throws VWException {
        String m_method = "getDestination";
        RemoteException saveLastException = null;
        RetryManager retry = new RetryManager(RPC_TIMEOUT);
        do {
            try {
                this.commandInterface = router.getSession(destination);
                retry.stop();
            }
            catch (ConnectException cex) {
                VWCommandSession ses = this.parentSession != null ? this.parentSession : this;
                ses.resetRouterConnection();
                saveLastException = cex;
                router = ses.getRouter();
            }
            catch (RemoteException ce) {
                logger.finest(this.m_className, m_method, "Remote exception...retrying");
                this.reinit();
                saveLastException = ce;
            }
            catch (Exception e) {
                logger.throwing(this.m_className, m_method, e);
                retry.stop();
            }
        } while (retry.again());
        logger.finest(this.m_className, m_method, "after retry ");
        if (this.commandInterface != null) return;
        logger.finest(this.m_className, m_method, "commandInterface == null ");
        if (saveLastException == null) throw new VWException("vw.server.VWCommandSessionCommandInterfaceWasNull", "Could not establish connection with server. {0}", destination);
        if (!(saveLastException instanceof RemoteException)) throw new VWException("vw.server.VWCommandSessionGetDestinationFailed", "Get Destination Error {0} to {1}.", ((Throwable)saveLastException).getMessage(), destination);
        this.unpackRemoteException(saveLastException);
    }

    protected void unpackRemoteException(RemoteException re) throws VWException {
        String m_method = "unpackRemoteException";
        if (re.detail != null) {
            if (re.detail instanceof VWException) {
                throw (VWException)re.detail;
            }
            logger.throwing(this.m_className, m_method, re);
        }
        VWException vwe = new VWException("vw.server.VWCommandSessionUnknownRemoteException", "Unknown RemoteException. {0}", re.getMessage());
        vwe.setCause(re);
        throw vwe;
    }

    protected IVWRouter getRouter() throws VWException {
        String m_method = "getRouter";
        logger.finest(this.m_className, m_method, "start getRouter commandInterface=" + this.commandInterface);
        if (this.commandInterface == null) {
            this.resetRouterConnection();
        }
        if (this.commandInterface instanceof IVWRouter) {
            return (IVWRouter)((Object)this.commandInterface);
        }
        logger.finest(this.m_className, m_method, "return null");
        return null;
    }

    protected void resetRouterConnection() throws VWException {
        String m_method = "resetRouterConnection";
        logger.finest(this.m_className, m_method, "start resetRouterConnection, router URL=" + this.theRouterURL);
        try {
            this.commandInterface = null;
            if (this.parentSession == null) {
                logger.finest(this.m_className, m_method, "parentSession is null, reset the router with URL=" + this.theRouterURL);
                this.init(this.theRouterURL, null);
            } else {
                logger.finest(this.m_className, m_method, "Use the parent session to route to the new session");
                this.getDestination(this.parentSession.getRouter(), this.theDestination);
            }
        }
        catch (VWException ex) {
            VWException vwe = new VWException("vw.server.VWCommandSessionResetRouterConnect", "Could not re-establish router connection. Router may be down. {0}", ex.getMessage());
            vwe.setCause(ex);
            throw vwe;
        }
    }

    protected void checkReturnType(Class expectedReturnType, Object result) throws VWException {
        if (expectedReturnType != null) {
            if (result == null) {
                if (expectedReturnType != Void.TYPE) {
                    throw new VWException("vw.server.VWCommandSessionUnexpectedNullResult", "Command result was unexpectedly null.");
                }
                return;
            }
            if (result.getClass() != expectedReturnType) {
                throw new VWException("vw.server.VWCommandSessionIncorrectResultType", "Command result was not of expected type.");
            }
        }
    }

    protected synchronized Object command(int RPCNumber, Object[] params, Class expectedReturnType, boolean viewIdCmd) throws VWException {
        VWServerCommand serverCommand;
        int viewId = 0;
        if (viewIdCmd) {
            serverCommand = new VWViewIdCommand(RPCNumber, params);
            try {
                viewId = (Integer)params[1];
            }
            catch (Throwable e) {}
        } else {
            serverCommand = new VWServerCommand(RPCNumber, params);
        }
        Object result = this.sendCommand(RPCNumber, serverCommand, null, null, viewId);
        this.checkReturnType(expectedReturnType, result);
        return result;
    }

    protected synchronized Object sendCommand(int RPCNumber, VWServerCommand serverCommand, byte[][] handles, int[] ids, int viewId) throws VWException {
        String m_method = "sendCommand RPC=" + Integer.toString(RPCNumber);
        logger.entering(this.m_className, m_method);
        VWCommandResult result = null;
        Object[] lhandles = null;
        if (this.commandInterface == null) {
            this.resetRouterConnection();
        }
        if (this.logonHandle == null) {
            int i;
            serverCommand.setCredentials(this.logonCreds);
            logger.finest(this.m_className, m_method, "logonHandle=null");
            if (this.parentSession == null) {
                if (this.serverCount > 0) {
                    logger.finest(this.m_className, m_method, "is parent, serverCount=" + Integer.toString(this.serverCount));
                    this.logonCreds.setUserFirstLogon(false);
                    lhandles = new VWLogonHandle[this.serverCount];
                    ids = new int[this.serverCount];
                    for (i = 0; i < this.serverCount; ++i) {
                        lhandles[i] = this.logonHandles[i];
                        ids[i] = this.serverIds[i];
                    }
                } else {
                    this.logonCreds.setUserFirstLogon(true);
                    ids = new int[1];
                }
            } else if (this.parentSession.serverCount > 0) {
                logger.finest(this.m_className, m_method, "parent's serverCount=" + Integer.toString(this.parentSession.serverCount));
                lhandles = new VWLogonHandle[this.parentSession.serverCount];
                ids = new int[this.parentSession.serverCount];
                for (i = 0; i < this.parentSession.serverCount; ++i) {
                    lhandles[i] = this.parentSession.logonHandles[i];
                    ids[i] = this.parentSession.serverIds[i];
                }
            } else {
                ids = new int[1];
            }
            logger.finest(this.m_className, m_method, lhandles == null ? "null handles" : "NOT null handles, len=" + lhandles.length);
            if (lhandles != null) {
                handles = VWCommandSession.HandlesToByteArray(lhandles, RPCNumber);
            }
            logger.finest(this.m_className, m_method, "handle =" + handles);
        } else {
            VWCommandSession ses;
            this.logonCreds.setUserFirstLogon(false);
            logger.finest(this.m_className, m_method, "logonhandle NOT NULL" + this.logonHandle);
            VWCommandSession vWCommandSession = ses = this.parentSession != null ? this.parentSession : this;
            if (this.serverId != -1) {
                for (int i = 0; i < ses.serverCount; ++i) {
                    if (this.serverId != ses.serverIds[i]) continue;
                    if (this.logonHandle == ses.logonHandles[i]) break;
                    this.logonHandle = ses.logonHandles[i];
                    break;
                }
            }
            serverCommand.setLogonHandle(this.logonHandle);
        }
        Exception saveLastException = null;
        try {
            int transferRetryCnt = -1;
            RetryManager retry = new RetryManager(RPC_TIMEOUT);
            do {
                try {
                    result = VWCommandResult.fromBytes(this.commandInterface.sendCommand(RPCNumber, serverCommand.toBytes(RPCNumber), viewId, handles, ids), RPCNumber);
                    retry.stop();
                }
                catch (ConnectException cex) {
                    logger.finest(this.m_className, m_method, "Connection exception...retrying");
                    this.resetRouterConnection();
                    saveLastException = cex;
                }
                catch (RemoteException ce) {
                    logger.finest(this.m_className, m_method, "Remote exception...retrying");
                    this.reinit();
                    saveLastException = ce;
                }
                catch (VWViewDoesNotExistException ve) {
                    logger.finest(this.m_className, m_method, "View does not exist exception...retrying");
                    saveLastException = ve;
                }
                catch (VWStaleLogonException sle) {
                    VWCommandSession ses;
                    logger.finest(this.m_className, m_method, "Stale logon exception...retrying");
                    serverCommand.setCredentials(this.logonCreds);
                    serverCommand.setLogonHandle(new VWLogonHandle());
                    int theServerId = sle.getServerId();
                    int icount = 0;
                    VWCommandSession vWCommandSession = ses = this.parentSession != null ? this.parentSession : this;
                    if (ses.serverCount > 0) {
                        if (theServerId == -1) {
                            lhandles = new VWLogonHandle[ses.serverCount];
                            ids = new int[ses.serverCount];
                        } else {
                            lhandles = new VWLogonHandle[ses.serverCount - 1];
                            ids = new int[ses.serverCount - 1];
                        }
                        if (ids.length > 0) {
                            for (int i = 0; i < ses.serverCount; ++i) {
                                if (ses.serverIds[i] == theServerId) continue;
                                lhandles[icount] = ses.logonHandles[i];
                                ids[icount] = ses.serverIds[i];
                                ++icount;
                            }
                        }
                    }
                    if (ids == null) {
                        ids = new int[]{};
                    }
                    logger.finest(this.m_className, m_method, "handle is STALE " + sle.getServerId() + "handles length" + lhandles.length);
                    if (lhandles != null) {
                        handles = VWCommandSession.HandlesToByteArray(lhandles, RPCNumber);
                    }
                    saveLastException = sle;
                }
                catch (VWOpNotAllowedException de) {
                    logger.finest(this.m_className, m_method, "Operation not allowed exception...retrying");
                    if (++transferRetryCnt > 90) {
                        retry.stop();
                        continue;
                    }
                    saveLastException = de;
                    Thread.sleep(3000L);
                }
            } while (retry.again());
        }
        catch (VWNoOnlineClassesException ex) {
            throw ex;
        }
        catch (Exception e) {
            logger.throwing(this.m_className, m_method, e);
            if (e instanceof VWException) {
                throw (VWException)e;
            }
            if (e instanceof RemoteException) {
                this.unpackRemoteException((RemoteException)e);
            }
            VWException vwe = new VWException("vw.server.VWCommandSessionSendCommandError", "SendCommand Error {0}.", e.getMessage());
            vwe.setCause(e);
            throw vwe;
        }
        if (result == null) {
            if (saveLastException != null) {
                VWException vwe = null;
                if (saveLastException instanceof VWStaleLogonException) {
                    vwe = new VWException("vw.server.VWCommandSessionLogonRefreshFailed", "Logon refresh attempt failed.");
                }
                if (saveLastException instanceof VWException) {
                    vwe = (VWException)saveLastException;
                }
                if (saveLastException instanceof RemoteException) {
                    this.unpackRemoteException((RemoteException)saveLastException);
                } else {
                    vwe = new VWException("vw.server.VWCommandSessionSendCommandRetryFail", "SendCommand Error {0}.", saveLastException.getMessage());
                }
                vwe.setCause(saveLastException);
                throw vwe;
            }
            throw new VWException("vw.server.VWCommandSessionCommandResultWasNull", "Command result was null.");
        }
        logger.finest(this.m_className, m_method, "results not null");
        if (result.logonResult != null) {
            VWCommandSession ses;
            this.logonHandle = result.logonResult.logonHandle;
            if (this.logonHandle == null) {
                throw new VWException("vw.server.VWCommandSessionLogonHandleWasNull", "Result logonHandle is NULL.");
            }
            this.serverId = result.logonResult.getServerId();
            if (this.serverId == -1) {
                throw new VWException("vw.server.VWCommandSessionServerIdNotSet", "Result Server Id was not set.");
            }
            this.logonCreds = result.logonResult.getLogonCredentials();
            if (this.logonCreds == null) {
                throw new VWException("vw.server.VWCommandSessionLogonCredsWasNull", "Result logon credentials are NULL.");
            }
            boolean found_id = false;
            VWCommandSession vWCommandSession = ses = this.parentSession != null ? this.parentSession : this;
            if (ses.logonHandles == null) {
                ses.logonHandles = new VWLogonHandle[100];
                ses.serverIds = new int[100];
            } else {
                for (int i = 0; i < ses.serverCount; ++i) {
                    if (ses.serverIds[i] != this.serverId) continue;
                    ses.logonHandles[i] = this.logonHandle;
                    found_id = true;
                }
            }
            if (!found_id) {
                ses.logonHandles[ses.serverCount] = this.logonHandle;
                ses.serverIds[ses.serverCount] = this.serverId;
                ++ses.serverCount;
            }
            logger.finest(this.m_className, m_method, "set logon handle" + this.logonHandle + " " + this.serverId);
        }
        logger.exiting(this.m_className, m_method);
        return result.commandResult;
    }

    public void createHandleArray(VWLogonHandle[] lhandles, int[] ids, int theServerId) {
        VWCommandSession ses;
        String m_method = "createHandleArray";
        int icount = 0;
        logger.finest(this.m_className, m_method, "STALE id for" + theServerId);
        VWCommandSession vWCommandSession = ses = this.parentSession != null ? this.parentSession : this;
        if (ses.serverCount > 0) {
            if (theServerId == -1) {
                lhandles = new VWLogonHandle[ses.serverCount];
                ids = new int[ses.serverCount];
            } else {
                lhandles = new VWLogonHandle[ses.serverCount - 1];
                ids = new int[ses.serverCount - 1];
            }
            if (ids.length > 0) {
                for (int i = 0; i < ses.serverCount; ++i) {
                    if (ses.serverIds[i] == theServerId) continue;
                    lhandles[icount] = ses.logonHandles[i];
                    ids[icount] = ses.serverIds[i];
                    ++icount;
                }
            }
        }
        if (ids == null) {
            ids = new int[]{};
        }
        logger.finest(this.m_className, m_method, "number of Handles" + lhandles.length);
    }

    public static String formatURL(String aName) {
        String url = aName;
        if (!url.toUpperCase(Locale.ENGLISH).startsWith("RMI://")) {
            if (!url.startsWith("//")) {
                url = "//" + url;
            }
            url = "rmi:" + url;
        }
        String slash = "\\";
        int len = url.length();
        int inx = url.lastIndexOf(slash);
        if (inx == len - 1) {
            url = url.substring(0, inx - 1);
        }
        return url;
    }

    public static String serviceDestination(String serviceRouterURL) {
        String result = null;
        String slash = "/";
        int len = serviceRouterURL.length();
        int inx = serviceRouterURL.lastIndexOf(slash);
        boolean trailslash = false;
        if (inx == len - 1) {
            inx = serviceRouterURL.lastIndexOf(slash, inx - 1);
            trailslash = true;
        }
        if (inx != -1) {
            result = trailslash ? serviceRouterURL.substring(inx + 1, len - 2) : serviceRouterURL.substring(inx + 1);
        } else if (len > 0) {
            result = serviceRouterURL;
        }
        if (!result.toUpperCase(Locale.ENGLISH).startsWith("FILENET.VW.VWROUTER.")) {
            return "FileNET.VW.VWRouter." + result;
        }
        return result;
    }

    public static String serverDestination(String serviceRouterURL, int serverNum, int isolatedRegion) {
        String result = VWCommandSession.serviceDestination(serviceRouterURL);
        result = result + ".Server" + serverNum;
        return result;
    }

    public static String queueDestination(String serviceRouterURL, int isolatedRegion, String queueName, int serverId) {
        StringTokenizer stmp = new StringTokenizer(queueName, ":");
        String qname = null;
        if (stmp.hasMoreTokens()) {
            qname = stmp.nextToken();
        }
        if (serverId != -1) {
            qname = qname + "(" + serverId + ")";
        }
        String s = VWCommandSession.serviceDestination(serviceRouterURL) + ".Queue." + qname;
        logger.finest("VWCommandSession", "queueDestination", s);
        return s;
    }

    public static String rosterDestination(String serviceRouterURL, int isolatedRegion, String rosterName) {
        StringTokenizer stmp = new StringTokenizer(rosterName, ":");
        String rname = null;
        if (stmp.hasMoreTokens()) {
            rname = stmp.nextToken();
        }
        return VWCommandSession.serviceDestination(serviceRouterURL) + ".Roster." + rname;
    }

    public VWLogonResult logon(VWLogonCredentials credentials) throws VWException {
        String m_method = "logon";
        VWServerCommand logonCmd = new VWServerCommand(null, null);
        logger.entering(this.m_className, m_method + "(" + this.logonCreds.getUserName() + ")");
        Object result = this.sendCommand(1, logonCmd, null, null, 0);
        this.m_className = "VWCommandSession:" + (this.logonCreds == null ? "null" : this.logonCreds.getUserName()) + ", " + this.theRouterURL;
        logger.exiting(this.m_className, m_method + "(" + this.logonCreds.getUserName() + ")");
        return null;
    }

    public void logoff() throws VWException {
        String m_method = "logoff serverId=" + this.serverId;
        logger.entering(this.m_className, m_method);
        if (this.parentSession == null && this.childSessions != null) {
            Enumeration theChildren = this.childSessions.keys();
            int childCount = this.childSessions.size();
            if (childCount != 0 && this.serverCount != 0) {
                int logoffCnt = 0;
                boolean done = false;
                boolean found = false;
                String name = null;
                logger.finest(this.m_className, m_method, "childCount=" + childCount);
                for (int i = 0; i < childCount && !done; ++i) {
                    name = (String)theChildren.nextElement();
                    int id = ((VWCommandSession)this.childSessions.get((Object)name)).serverId;
                    if (id != this.serverId) {
                        found = false;
                        for (int j = 0; j < this.serverCount && !found; ++j) {
                            if (id != this.serverIds[j]) continue;
                            try {
                                ((VWCommandSession)this.childSessions.get(name)).logoff();
                            }
                            catch (Exception e) {
                                logger.throwing(this.m_className, m_method + " (IGNORABLE)", e);
                            }
                            this.serverIds[j] = -1;
                            ++logoffCnt;
                            found = true;
                        }
                    }
                    if (logoffCnt != true) continue;
                    done = true;
                }
            }
        }
        if (this.commandInterface != null) {
            this.command(2, new Object[]{new VWLogonHandle()}, Void.TYPE, false);
        }
        logger.exiting(this.m_className, m_method);
    }

    public Hashtable getUserNames() throws VWException {
        String m_method = "getUserNames";
        logger.entering(this.m_className, m_method);
        Hashtable results = (Hashtable)this.command(3, new Object[]{new VWLogonHandle()}, Hashtable.class, false);
        logger.exiting(this.m_className, m_method + " RESULTS=" + Logger.count(results));
        return results;
    }

    public VWSecurityQueryResults fetchUserList(int maxNumToReturn, int queryType, String startRecord, String searchPattern, String domain, int searchType, int sortType, long argFlag) throws VWException {
        String m_method = "fetchUserList";
        logger.entering(this.m_className, m_method);
        VWSecurityQueryResults results = (VWSecurityQueryResults)this.command(13, new Object[]{new VWLogonHandle(), new Integer(maxNumToReturn), new Integer(queryType), startRecord, searchPattern, domain, new Integer(searchType), new Integer(sortType), new Long(argFlag)}, VWSecurityQueryResults.class, false);
        logger.exiting(this.m_className, m_method + ", RESULTS=" + Logger.count(results));
        return results;
    }

    public VWConfigResult getConfigInfo(boolean refresh) throws VWException {
        String m_method = "getConfigInfo";
        logger.entering(this.m_className, m_method);
        VWConfigResult result = (VWConfigResult)this.command(4, new Object[]{new VWLogonHandle()}, VWConfigResult.class, false);
        logger.exiting(this.m_className, m_method);
        return result;
    }

    public Boolean recoverUser(String userName, String[] queueNames) throws VWException {
        String m_method = "recoverUser, user=" + userName + ", q=" + Logger.asString(queueNames);
        logger.entering(this.m_className, m_method);
        Boolean result = (Boolean)this.command(30, new Object[]{new VWLogonHandle(), userName, queueNames}, Boolean.class, false);
        logger.exiting(this.m_className, m_method);
        return result;
    }

    public String[] getQueueOperations(String queueName) throws VWException {
        String m_method = "getQueueOperation(" + queueName + ")";
        logger.entering(this.m_className, m_method);
        String[] results = (String[])this.command(40, new Object[]{new VWLogonHandle(), queueName}, String[].class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public String[] getQueueNames(boolean includeSystemQueues, boolean ignoreSecurity) throws VWException {
        String m_method = "getQueueNames " + includeSystemQueues;
        logger.entering(this.m_className, m_method);
        String[] results = (String[])this.command(31, new Object[]{new VWLogonHandle(), new Boolean(includeSystemQueues), new Boolean(ignoreSecurity)}, String[].class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public String[] getRosterNames(boolean ignoreSecurity) throws VWException {
        String m_method = "getRosterNames";
        logger.entering(this.m_className, m_method);
        String[] results = (String[])this.command(60, new Object[]{new VWLogonHandle(), new Boolean(ignoreSecurity)}, String[].class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public String[] getWorkClassNames(boolean ignoreSecurity, String baseWorkClassName) throws VWException {
        String m_method = "getWorkClassNames";
        logger.entering(this.m_className, m_method);
        String[] results = (String[])this.command(20, new Object[]{new VWLogonHandle(), new Boolean(ignoreSecurity), baseWorkClassName}, String[].class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public VWAttributeInfo getAttributes(int nFlag) throws VWException {
        String m_method = "getAttributes";
        logger.entering(this.m_className, m_method);
        VWAttributeInfo results = (VWAttributeInfo)this.command(26, new Object[]{new VWLogonHandle(), new Integer(nFlag)}, VWAttributeInfo.class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public VWProcess getProcess(int workSpaceId, int workClassId, String workflowNumber) throws VWException {
        String m_method = "getProcess " + workflowNumber;
        logger.entering(this.m_className, m_method);
        VWProcess results = (VWProcess)this.command(21, new Object[]{new VWLogonHandle(), new Integer(workSpaceId), new Integer(workClassId), workflowNumber}, VWProcess.class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public String[] getLogNames() throws VWException {
        String m_method = "getLogNames";
        logger.entering(this.m_className, m_method);
        String[] results = (String[])this.command(350, new Object[]{new VWLogonHandle()}, String[].class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public String getCurrentVersion() throws VWException {
        String m_method = "getCurrentVersion";
        logger.entering(this.m_className, m_method);
        String result = (String)this.command(5, new Object[]{new VWLogonHandle()}, String.class, false);
        logger.exiting(this.m_className, m_method);
        return result;
    }

    public VWField[] getNewWorkObjectFields(String rosterName) throws VWException {
        String m_method = "getNewWorkObjectFields " + rosterName;
        logger.entering(this.m_className, m_method);
        VWField[] results = (VWField[])this.command(62, new Object[]{new VWLogonHandle(), rosterName}, VWField[].class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public VWQueryResults fetch(int viewId, int queryType, int resultType, int maxNumToReturn, String indexName, Object[] minValues, Object[] maxValues, int queryFlags, String preFilterSQL, Object[] substitutionVarNames, VWWorkRecord startRecord, double rpUniqueId, boolean userBoundQuery, String logName, int workBasketId, String sortColumn, String[] filterNames) throws VWException {
        String m_method = "fetch";
        logger.entering(this.m_className, m_method);
        StringBuffer buf = new StringBuffer();
        buf.append("QT:").append(queryType);
        buf.append(", RT:").append(resultType);
        buf.append(", Max:").append(maxNumToReturn);
        buf.append(", IName:").append(indexName);
        buf.append(", minValues:").append(Logger.asString(minValues));
        buf.append(", maxValues:").append(Logger.asString(maxValues));
        buf.append(", QFlag:").append(queryFlags);
        buf.append(", filter:").append(preFilterSQL);
        buf.append(", substitutionVarNames:").append(Logger.asString(substitutionVarNames));
        buf.append(", startRecord:").append(Logger.asString(startRecord));
        logger.finest(this.m_className, m_method, buf.toString());
        VWQueryResults results = (VWQueryResults)this.command(6, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(queryType), new Integer(resultType), new Integer(maxNumToReturn), indexName, minValues, maxValues, new Integer(queryFlags), preFilterSQL, substitutionVarNames, startRecord, new Double(rpUniqueId), new Boolean(userBoundQuery), logName}, VWQueryResults.class, true);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public Integer fetchCount(int viewId, int queryType, int resultType, String indexName, Object[] minValues, Object[] maxValues, int queryFlags, String preFilterSQL, Object[] substitutionVarNames, boolean userBoundQuery, String logName, int workBasketId, String sortColumn, String[] filterNames) throws VWException {
        String m_method = "fetchCount";
        logger.entering(this.m_className, m_method);
        StringBuffer buf = new StringBuffer();
        buf.append("QT:").append(queryType);
        buf.append(", RT:").append(resultType);
        buf.append(", IName:").append(indexName);
        buf.append(", minValues:").append(Logger.asString(minValues));
        buf.append(", maxValues:").append(Logger.asString(maxValues));
        buf.append(", QFlag:").append(queryFlags);
        buf.append(", filter:").append(preFilterSQL);
        buf.append(", substitutionVarNames:").append(Logger.asString(substitutionVarNames));
        logger.finest(this.m_className, m_method, buf.toString());
        Integer results = (Integer)this.command(19, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(queryType), new Integer(resultType), indexName, minValues, maxValues, new Integer(queryFlags), preFilterSQL, substitutionVarNames, new Boolean(userBoundQuery), logName, workBasketId, sortColumn, filterNames}, Integer.class, true);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public Integer getQueueDepth(int viewId, boolean userBoundQuery) throws VWException {
        String m_method = "getQueueDepth";
        logger.entering(this.m_className, m_method);
        Integer result = (Integer)this.command(32, new Object[]{new VWLogonHandle(), new Integer(viewId), new Boolean(userBoundQuery)}, Integer.class, true);
        logger.exiting(this.m_className, m_method);
        return result;
    }

    public Integer getRosterCount(int viewId) throws VWException {
        String m_method = "getRosterCount";
        logger.entering(this.m_className, m_method);
        Integer result = (Integer)this.command(61, new Object[]{new VWLogonHandle(), new Integer(viewId)}, Integer.class, true);
        logger.exiting(this.m_className, m_method);
        return result;
    }

    public Boolean getLoggingState(int viewId, int loggingOption) throws VWException {
        String m_method = "getLoggingState";
        logger.entering(this.m_className, m_method);
        Boolean result = (Boolean)this.command(11, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(loggingOption)}, Boolean.class, true);
        logger.exiting(this.m_className, m_method);
        return result;
    }

    public Hashtable getAllServers() throws VWException {
        String m_method = "getAllServers";
        logger.entering(this.m_className, m_method);
        Hashtable results = (Hashtable)this.command(12, new Object[]{new VWLogonHandle()}, Hashtable.class, false);
        logger.exiting(this.m_className, m_method + " RESULT=" + Logger.count(results));
        return results;
    }

    public void logMessage(int viewId, int loggingOption, String message) throws VWException {
        String m_method = "logMessage";
        logger.entering(this.m_className, m_method);
        this.command(33, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(loggingOption), message}, Void.TYPE, true);
        logger.exiting(this.m_className, m_method);
    }

    public Object[] getLockStatus(int viewId, int queryType, VWWorkObjectID[] wobjHandles, boolean throwException, boolean userBoundQuery) throws VWException {
        String m_method = "getLockStatus queryType=" + queryType;
        logger.entering(this.m_className, m_method);
        Object[] results = (Object[])this.command(9, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(queryType), wobjHandles, new Boolean(throwException), new Boolean(userBoundQuery)}, Object[].class, true);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public Object[] unlockSave(int viewId, int queryType, VWWorkObjectID[] workObjectIds, int saveType, VWField[][] fieldValues, boolean bindAll, String userToBind, String exception, String exceptionDescription, boolean isExceptionMap, boolean unlockAll, boolean dispatchAll, boolean throwException, boolean userBoundQuery) throws VWException {
        String m_method = "UnlockSave";
        logger.entering(this.m_className, m_method);
        StringBuffer buf = new StringBuffer();
        buf.append("QT:").append(queryType);
        buf.append(", ST:").append(saveType);
        buf.append(", ULockAll:").append(unlockAll);
        buf.append(", DAll:").append(dispatchAll);
        buf.append(", TE:").append(throwException);
        buf.append("-- UnlockSave work object number count = ").append(workObjectIds == null ? "0" : Integer.toString(workObjectIds.length));
        logger.finest(this.m_className, m_method, buf.toString());
        Object[] results = (Object[])this.command(8, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(queryType), workObjectIds, new Integer(saveType), fieldValues, new Boolean(bindAll), userToBind, exception, exceptionDescription, new Boolean(isExceptionMap), new Boolean(unlockAll), new Boolean(dispatchAll), new Boolean(throwException), new Boolean(userBoundQuery)}, Object[].class, true);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public Boolean inject(String rosterName, VWField[][] fieldValues, String[] rosterNames, String sessionName, String transactionName) throws VWException {
        String m_method = "inject " + rosterName;
        logger.entering(this.m_className, m_method);
        Boolean result = (Boolean)this.command(63, new Object[]{new VWLogonHandle(), rosterName, fieldValues, rosterNames, sessionName, transactionName}, Boolean.class, false);
        logger.exiting(this.m_className, m_method, result);
        return result;
    }

    public VWInjectInfo getInjectSessionInfo(String rosterName, String sessionName, boolean nextName) throws VWException {
        String m_method = "getInjectSessionInfo " + rosterName + " SN:" + sessionName + " NN:" + nextName;
        logger.entering(this.m_className, m_method);
        VWInjectInfo result = (VWInjectInfo)this.command(64, new Object[]{new VWLogonHandle(), rosterName, sessionName, new Boolean(nextName)}, VWInjectInfo.class, false);
        logger.exiting(this.m_className, m_method);
        return result;
    }

    public Boolean deleteInjectSession(String rosterName, String sessionName) throws VWException {
        String m_method = "deleteInjectSession " + rosterName + " SS:" + sessionName;
        logger.entering(this.m_className, m_method);
        Boolean result = (Boolean)this.command(65, new Object[]{new VWLogonHandle(), rosterName, sessionName}, Boolean.class, false);
        logger.exiting(this.m_className, m_method, result);
        return result;
    }

    public Object[] getWorkElementFields(int viewId, int queryType, VWWorkObjectID[] workObjectIds, int resultType, boolean lock, boolean overrideLock, boolean userBoundQuery, int queryFlags, int thecommand) throws VWException {
        String m_method = "getWorkElementFields";
        logger.entering(this.m_className, m_method);
        StringBuffer buf = new StringBuffer();
        buf.append("QT:").append(queryType);
        buf.append(", RT:").append(resultType);
        buf.append(", Lock:").append(lock);
        buf.append(", OLock:").append(overrideLock);
        buf.append(", queryFlags:").append(queryFlags);
        buf.append("-- work object count = ").append(Logger.count(workObjectIds));
        logger.finest(this.m_className, m_method, buf.toString());
        Object[] results = null;
        if (queryType != 2 && queryType != 1) {
            throw new VWException("vw.server.VWCommandSessiongetWorkElementFieldsBadQType", "Bad Query Type{0}", new Integer(queryType).toString());
        }
        results = (Object[])this.command(7, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(queryType), workObjectIds, new Integer(resultType), new Boolean(lock), new Boolean(overrideLock), new Boolean(userBoundQuery), new Integer(queryFlags), new Integer(thecommand)}, Object[].class, true);
        logger.exiting(this.m_className, m_method, " RESULTS=" + Logger.count(results));
        return results;
    }

    public Hashtable getIndexFields(String queueName) throws VWException {
        String m_method = "getIndexFields " + queueName;
        logger.entering(this.m_className, m_method);
        Hashtable results = (Hashtable)this.command(35, new Object[]{new VWLogonHandle(), queueName}, Hashtable.class, false);
        logger.exiting(this.m_className, m_method, "RESULTS=" + Logger.count(results));
        return results;
    }

    public String[] getExposedFields(String queueName) throws VWException {
        String m_method = "getExposedFields " + queueName;
        logger.entering(this.m_className, m_method);
        String[] results = (String[])this.command(34, new Object[]{new VWLogonHandle(), queueName}, String[].class, false);
        logger.exiting(this.m_className, m_method, "RESULTS=" + Logger.asString(results));
        return results;
    }

    public Object[] terminateWorkObject(int viewId, int queryType, VWWorkObjectID[] wobjHandles, boolean throwException, boolean userBoundQuery) throws VWException {
        String m_method = "terminateWorkObject";
        logger.entering(this.m_className, m_method);
        StringBuffer buf = new StringBuffer();
        buf.append("QT:").append(queryType);
        buf.append(", TE:").append(throwException);
        buf.append("-- work object count = ").append(Logger.count(wobjHandles));
        logger.finest(this.m_className, m_method, buf.toString());
        Object[] results = (Object[])this.command(10, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(queryType), wobjHandles, new Boolean(throwException), new Boolean(userBoundQuery)}, Object[].class, true);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public Object[] deleteWorkObject(int viewId, int queryType, VWWorkObjectID[] wobjHandles, boolean overrideLock, boolean force, boolean throwException, boolean userBoundQuery) throws VWException {
        String m_method = "deleteWorkObject";
        logger.entering(this.m_className, m_method);
        StringBuffer buf = new StringBuffer();
        buf.append("QT:").append(queryType);
        buf.append(", TE:").append(throwException);
        buf.append("-- work object count = ").append(Logger.count(wobjHandles));
        logger.finest(this.m_className, m_method, buf.toString());
        Object[] results = (Object[])this.command(25, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(queryType), wobjHandles, new Boolean(overrideLock), new Boolean(force), new Boolean(throwException), new Boolean(userBoundQuery)}, Object[].class, true);
        logger.exiting(this.m_className, m_method, "RESULTS=" + Logger.count(results));
        return results;
    }

    public synchronized void updateLogonTable(VWLogonHandle handle, int id) {
        VWCommandSession ses;
        VWCommandSession vWCommandSession = ses = this.parentSession != null ? this.parentSession : this;
        if (ses.logonHandles == null) {
            ses.logonHandles = new VWLogonHandle[100];
            ses.serverIds = new int[100];
        } else {
            for (int i = 0; i < ses.serverCount; ++i) {
                if (ses.serverIds[i] != id) continue;
                ses.logonHandles[this.serverCount] = handle;
                return;
            }
        }
        ses.logonHandles[ses.serverCount] = handle;
        ses.serverIds[ses.serverCount] = id;
        ++ses.serverCount;
    }

    public synchronized void updateChildSession(VWCommandSession newSession) {
        String m_method = "updateChildSession";
        if (this.parentSession == null) {
            String name = newSession.theDestination;
            logger.finest(this.m_className, m_method, "name:" + name);
            if (this.childSessions == null) {
                this.childSessions = new Hashtable(1);
            } else if (this.childSessions.containsKey(name)) {
                this.childSessions.remove(name);
            }
            this.childSessions.put(name, newSession);
        } else {
            this.parentSession.updateChildSession(newSession);
        }
    }

    public synchronized VWCommandSession findSession(String destination) {
        VWCommandSession ses;
        VWCommandSession vWCommandSession = ses = this.parentSession != null ? this.parentSession : this;
        if (ses.childSessions != null && ses.childSessions.containsKey(destination)) {
            return (VWCommandSession)ses.childSessions.get(destination);
        }
        return null;
    }

    public static byte[][] HandlesToByteArray(Object[] objArr, int RPCNumber) throws VWException {
        Object result = null;
        if (objArr != null) {
            result = new byte[objArr.length][];
            for (int i = 0; i < objArr.length; ++i) {
                byte[] item = ((VWLogonHandle)objArr[i]).toBytes();
                result[i] = item;
            }
        }
        return result;
    }

    public static VWLogonHandle[] HandlesFromByteArray(byte[][] bytes, int RPCNumber) throws IOException, ClassNotFoundException {
        VWLogonHandle[] result = null;
        if (bytes != null) {
            int len = bytes.length;
            if (len == 0) {
                return null;
            }
            result = new VWLogonHandle[len];
            for (int i = 0; i < len; ++i) {
                VWLogonHandle item;
                if (bytes[i] == null) {
                    return null;
                }
                result[i] = item = VWLogonHandle.fromBytes(bytes[i]);
            }
        }
        return result;
    }

    public static synchronized void setAuditState(String fileName, Integer[] options) {
    }

    public void initializeAllRegions() throws VWException {
        String m_method = "initializeAllRegions";
        logger.entering(this.m_className, m_method);
        this.command(200, new Object[]{new VWLogonHandle()}, Void.TYPE, false);
        logger.exiting(this.m_className, m_method);
    }

    public void initializeRegion(boolean emptyIt, int webApp) throws VWException {
        String m_method = "initializeRegion";
        logger.entering(this.m_className, m_method);
        this.command(201, new Object[]{new VWLogonHandle(), new Boolean(emptyIt), new Integer(webApp)}, Void.TYPE, false);
        logger.exiting(this.m_className, m_method);
    }

    public void removeDatabase() throws VWException {
        String m_method = "removeDatabase";
        logger.entering(this.m_className, m_method);
        this.command(202, new Object[]{new VWLogonHandle()}, Void.TYPE, false);
        logger.exiting(this.m_className, m_method);
    }

    public VWSystemWideInfo getSystemWideConfig() throws VWException {
        String m_method = "getSystemWideConfig";
        logger.entering(this.m_className, m_method);
        VWSystemWideInfo results = (VWSystemWideInfo)this.command(203, new Object[]{new VWLogonHandle()}, VWSystemWideInfo.class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public void setSystemWideConfig(VWSystemWideInfo sysInfo) throws VWException {
        String m_method = "setSystemWideConfig " + sysInfo;
        logger.entering(this.m_className, m_method);
        this.command(204, new Object[]{new VWLogonHandle(), sysInfo}, Void.TYPE, false);
        logger.exiting(this.m_className, m_method);
    }

    public Hashtable fetchServerConfiguration(String[] keyList) throws VWException {
        String m_method = "fetchServerConfiguration";
        logger.entering(this.m_className, m_method);
        Hashtable results = (Hashtable)this.command(264, new Object[]{new VWLogonHandle(), keyList}, Hashtable.class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public VWEnvironmentData[] fetchUserInfo(String[] theUserNameList) throws VWException {
        String m_method = "fetchUserInfo ";
        logger.entering(this.m_className, m_method);
        VWEnvironmentData[] theResults = (VWEnvironmentData[])this.command(205, new Object[]{new VWLogonHandle(), theUserNameList}, VWEnvironmentData[].class, false);
        logger.exiting(this.m_className, m_method);
        return theResults;
    }

    public void saveUserInfo(VWEnvironmentData theUserInfo) throws VWException {
        String m_method = "saveUserInfo";
        logger.entering(this.m_className, m_method);
        logger.finest(this.m_className, m_method, "theUserInfo: " + theUserInfo);
        this.command(206, new Object[]{new VWLogonHandle(), theUserInfo}, Void.TYPE, false);
        logger.exiting(this.m_className, m_method);
    }

    public void deleteUserInfo(String theUserName) throws VWException {
        String m_method = "deleteUserInfo " + theUserName;
        logger.entering(this.m_className, m_method);
        this.command(207, new Object[]{new VWLogonHandle(), theUserName}, Void.TYPE, false);
        logger.exiting(this.m_className, m_method);
    }

    public VWSystemConfigInfo getSystemConfigInfo(int productId) throws VWException {
        String m_method = "getSystemConfigInfo";
        logger.entering(this.m_className, m_method);
        VWSystemConfigInfo theResults = (VWSystemConfigInfo)this.command(300, new Object[]{new VWLogonHandle(), new Integer(productId)}, VWSystemConfigInfo.class, false);
        logger.exiting(this.m_className, m_method);
        return theResults;
    }

    public VWTransferResult transfer(VWSystemConfigInfo systemConfigInfo, VWWorkflowDefinition wflDefinition, String theWFDocKey, boolean theLinked, boolean theMakeNewWorkSpace, int productId) throws VWException {
        String m_method = "transfer";
        logger.entering(this.m_className, m_method);
        VWTransferResult results = (VWTransferResult)this.command(301, new Object[]{new VWLogonHandle(), this.logonCreds, systemConfigInfo, wflDefinition, theWFDocKey, new Boolean(theLinked), new Boolean(theMakeNewWorkSpace), new Integer(productId)}, VWTransferResult.class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public VWRosterDefinition getRosterDefinition(String rosterName) throws VWException {
        String m_method = "getRosterDefinition " + rosterName;
        logger.entering(this.m_className, m_method);
        VWRosterDefinition theResults = (VWRosterDefinition)this.command(67, new Object[]{new VWLogonHandle(), rosterName}, VWRosterDefinition.class, false);
        logger.exiting(this.m_className, m_method);
        return theResults;
    }

    public VWQueueDefinition getQueueDefinition(String queueName) throws VWException {
        String m_method = "getQueueDefinition " + queueName;
        logger.entering(this.m_className, m_method);
        VWQueueDefinition theResults = (VWQueueDefinition)this.command(39, new Object[]{new VWLogonHandle(), queueName}, VWQueueDefinition.class, false);
        logger.exiting(this.m_className, m_method);
        return theResults;
    }

    public VWLogDefinition getLogDefinition(String logName) throws VWException {
        String m_method = "getLogDefinition " + logName;
        logger.entering(this.m_className, m_method);
        VWLogDefinition theResults = (VWLogDefinition)this.command(351, new Object[]{new VWLogonHandle(), logName}, VWLogDefinition.class, false);
        logger.exiting(this.m_className, m_method);
        return theResults;
    }

    public void doReject(int viewId, int queryType, VWWorkObjectID workObjectId, int saveType) throws VWException {
        String m_method = "doReject";
        logger.entering(this.m_className, m_method);
        this.command(36, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(queryType), workObjectId, new Integer(saveType)}, Void.TYPE, true);
        logger.exiting(this.m_className, m_method);
    }

    public void doReassign(int viewId, int queryType, VWWorkObjectID workObjectId, int saveType, String domainName, String participantName, boolean delegateFlag, String queueName, VWField[] fieldValues, String exception, String exceptionDescription, boolean isExceptionMap, boolean throwException, boolean userBoundQuery, long argFlag) throws VWException {
        String m_method = "doReassign";
        logger.entering(this.m_className, m_method);
        this.command(37, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(queryType), workObjectId, new Integer(saveType), domainName, participantName, new Boolean(delegateFlag), queueName, fieldValues, exception, exceptionDescription, new Boolean(isExceptionMap), new Boolean(throwException), new Boolean(userBoundQuery), new Long(argFlag)}, Void.TYPE, true);
        logger.exiting(this.m_className, m_method);
    }

    public void doReturn(int viewId, int queryType, VWWorkObjectID workObjectId, int saveType, VWField[] fieldValues, String exception, String exceptionDescription, boolean isExceptionMap, boolean throwException, boolean userBoundQuery) throws VWException {
        String m_method = "doReturn";
        logger.entering(this.m_className, m_method);
        this.command(41, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(queryType), workObjectId, new Integer(saveType), fieldValues, exception, exceptionDescription, new Boolean(isExceptionMap), new Boolean(throwException), new Boolean(userBoundQuery)}, Void.TYPE, true);
        logger.exiting(this.m_className, m_method);
    }

    public VWQueueStats getQueueStatistics(int viewId, Date startTime, Date endTime, int timeUnits) throws VWException {
        String m_method = "getQueueStatistics";
        logger.entering(this.m_className, m_method);
        VWQueueStats result = (VWQueueStats)this.command(38, new Object[]{new VWLogonHandle(), new Integer(viewId), startTime, endTime, new Integer(timeUnits)}, VWQueueStats.class, true);
        logger.exiting(this.m_className, m_method);
        return result;
    }

    public VWRosterStats getRosterStatistics(int viewId, Date startTime, Date endTime, int timeUnits) throws VWException {
        String m_method = "getRosterStatistics";
        logger.entering(this.m_className, m_method);
        VWRosterStats result = (VWRosterStats)this.command(66, new Object[]{new VWLogonHandle(), new Integer(viewId), startTime, endTime, new Integer(timeUnits)}, VWRosterStats.class, true);
        logger.exiting(this.m_className, m_method);
        return result;
    }

    public Boolean isMemberOfGroup(String groupName, String domainName, long rpcArgFlag) throws VWException {
        String m_method = "isMemberOfGroup " + groupName;
        logger.entering(this.m_className, m_method);
        Boolean result = (Boolean)this.command(14, new Object[]{new VWLogonHandle(), groupName, domainName, new Long(rpcArgFlag)}, Boolean.class, false);
        logger.exiting(this.m_className, m_method, result);
        return result;
    }

    public Boolean[] fetchIsGroup(String[] names) throws VWException {
        String m_method = "fetchIsGroup";
        logger.entering(this.m_className, m_method);
        Boolean[] results = (Boolean[])this.command(28, new Object[]{new VWLogonHandle(), names}, Boolean[].class, false);
        logger.exiting(this.m_className, m_method, "RESULTS=" + Logger.count(results));
        return results;
    }

    public Boolean[] fetchAttachmentIsReferenced(VWAttachment[] theAttachments) throws VWException {
        String m_method = "fetchAttachmentIsReferenced";
        logger.entering(this.m_className, m_method);
        Boolean[] results = (Boolean[])this.command(262, new Object[]{new VWLogonHandle(), theAttachments}, Boolean[].class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public VWQueryResults fetchAttachmentIsReferencedBy(VWAttachment theAttachment, int theLimit, int workClassId, String wobNum) throws VWException {
        String m_method = "fetchAttachmentIsReferencedBy";
        logger.entering(this.m_className, m_method);
        VWQueryResults results = (VWQueryResults)this.command(263, new Object[]{new VWLogonHandle(), theAttachment, new Integer(theLimit), new Integer(workClassId), wobNum}, VWQueryResults.class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public VWField[] getNewStepElement(String workClassName, boolean returnWobNum) throws VWException {
        String m_method = "getNewStepElement WC=" + workClassName;
        logger.entering(this.m_className, m_method);
        VWField[] results = (VWField[])this.command(15, new Object[]{new VWLogonHandle(), workClassName}, VWField[].class, false);
        logger.exiting(this.m_className, m_method, "RESULTS=" + Logger.count(results));
        return results;
    }

    public Object[] saveNewStepElement(VWField[] fieldValues, String workClassName, int workspaceId, VWField[] initialFieldValues) throws VWException {
        String m_method = "saveNewStepElement WC=" + workClassName + "  WS:=" + workspaceId;
        logger.entering(this.m_className, m_method);
        Object[] results = (Object[])this.command(16, new Object[]{new VWLogonHandle(), fieldValues, workClassName, new Integer(workspaceId), initialFieldValues}, Object[].class, false);
        logger.exiting(this.m_className, m_method, results);
        return results;
    }

    public VWField[] getNewStepFromVWVersion(String vwversion) throws VWException {
        String m_method = "getNewStepFromVWVersion, vwVersion=" + vwversion;
        logger.entering(this.m_className, m_method);
        VWField[] results = (VWField[])this.command(17, new Object[]{new VWLogonHandle(), vwversion}, VWField[].class, false);
        logger.exiting(this.m_className, m_method, "RESULTS=" + Logger.count(results));
        return results;
    }

    public Boolean checkVWVersion(String vwversion) throws VWException {
        String m_method = "checkVWVersion, vwVersion=" + vwversion;
        logger.entering(this.m_className, m_method);
        Boolean results = (Boolean)this.command(18, new Object[]{new VWLogonHandle(), vwversion}, Boolean.class, false);
        logger.exiting(this.m_className, m_method, results);
        return results;
    }

    public String getUserName() throws VWException {
        return this.logonCreds.getLogonName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getToken() throws VWException {
        String m_method = "getToken";
        String result = null;
        RetryManager retry = new RetryManager(RPC_TIMEOUT);
        ConnectException saveLastException = null;
        do {
            try {
                VWCapsule capb = new VWCapsule(this.logonCreds.getUserName());
                VWCapsule capa = new VWCapsule(this.logonCreds.getPassword());
                if (this.commandInterface != null) {
                    result = ((IVWRouter)((Object)this.commandInterface)).getToken(capb.getStr(), capa.getStr());
                }
                retry.stop();
            }
            catch (ServerError svrErr) {
                retry.stop();
            }
            catch (ConnectException cex) {
                this.resetRouterConnection();
                saveLastException = cex;
            }
            catch (RemoteException e) {
                logger.throwing(this.m_className, m_method, e);
                VWException vwe = new VWException("vw.api.VWCommandSessionGetToken", "Cannot get token.  {0}" + e.getMessage());
                vwe.setCause(e);
                throw vwe;
            }
        } while (retry.again());
        if (result == null) {
            logger.finest(this.m_className, m_method, "TRY OUR WAY...");
            result = this.encodeToken();
        }
        if (result != null) return result;
        if (saveLastException == null) throw new VWException("vw.api.VWCommandSessionGetToken", "Cannot get token.");
        if (saveLastException instanceof RemoteException) {
            this.unpackRemoteException(saveLastException);
            return result;
        } else {
            VWException vwe = new VWException("vw.server.VWCommandSessionGetToken", "Cannot get token.  {0}.", ((Throwable)saveLastException).getMessage());
            vwe.setCause(saveLastException);
            throw vwe;
        }
    }

    public void removeLinkFlag(String theDocument) throws VWException {
        String m_method = "removeLinkFlag, doc=" + theDocument;
        logger.entering(this.m_className, m_method);
        this.command(208, new Object[]{new VWLogonHandle(), theDocument}, Void.TYPE, false);
        logger.exiting(this.m_className, m_method);
    }

    public VWStepProcessorInfo[] getStepProcessorList(int processorType, int productId) throws VWException {
        String m_method = "getStepProcessorList";
        logger.entering(this.m_className, m_method);
        VWStepProcessorInfo[] results = (VWStepProcessorInfo[])this.command(250, new Object[]{new VWLogonHandle(), new Integer(processorType), new Integer(productId)}, VWStepProcessorInfo[].class, false);
        logger.exiting(this.m_className, m_method, "RESULTS=" + Logger.asString(results));
        return results;
    }

    public VWStepProcessorInfo getLaunchStepProcessor(String workflowIdentifier, int productId) throws VWException {
        String m_method = "getLaunchStepProcessor wfId=" + workflowIdentifier;
        logger.entering(this.m_className, m_method);
        VWStepProcessorInfo results = (VWStepProcessorInfo)this.command(251, new Object[]{new VWLogonHandle(), workflowIdentifier, new Integer(productId)}, VWStepProcessorInfo.class, false);
        logger.exiting(this.m_className, m_method, results);
        return results;
    }

    public VWStepProcessorInfo getStepProcessorByName(String processorName, int productId) throws VWException {
        String m_method = "getStepProcessorByName procName=" + processorName;
        logger.entering(this.m_className, m_method);
        VWStepProcessorInfo results = (VWStepProcessorInfo)this.command(252, new Object[]{new VWLogonHandle(), processorName, new Integer(productId)}, VWStepProcessorInfo.class, false);
        logger.exiting(this.m_className, m_method, results);
        return results;
    }

    public VWStepProcessorInfo getStepProcessorById(int processorId, int productId) throws VWException {
        String m_method = "getStepProcessorId procId=" + processorId;
        logger.entering(this.m_className, m_method);
        VWStepProcessorInfo results = (VWStepProcessorInfo)this.command(253, new Object[]{new VWLogonHandle(), new Integer(processorId), new Integer(productId)}, VWStepProcessorInfo.class, false);
        logger.exiting(this.m_className, m_method, results);
        return results;
    }

    public VWCreateLiveWOResult[] createLiveWorkObject(String[] fieldNames, Object[] fieldValues, String workflowIdentifier, int numberToCreate) throws VWException {
        int fieldType;
        String m_method = "createLiveWorkObject wfId=" + workflowIdentifier;
        logger.entering(this.m_className, m_method);
        VWField[] fields = null;
        if (92626 == numberToCreate && workflowIdentifier.startsWith("~") && workflowIdentifier.substring(2, 4).equals("~~")) {
            int i;
            numberToCreate = 1;
            int nFields = fieldNames.length + fieldValues.length;
            fields = new VWField[nFields];
            for (i = 0; i < fieldNames.length; ++i) {
                fieldType = VWFieldType.getVWFieldType(fieldNames[i]);
                fields[i] = new VWField("Fa" + String.valueOf(i), 3, fieldNames[i], false, fieldType, false, null);
            }
            for (int j = 0; j < fieldValues.length; ++j) {
                int fieldType2 = VWFieldType.getVWFieldType(fieldValues[j]);
                fields[i] = new VWField("Fb" + String.valueOf(i), 3, fieldValues[j], false, fieldType2, false, null);
                ++i;
            }
        } else if (fieldNames != null && fieldValues != null) {
            if (fieldNames.length != fieldValues.length) {
                throw new VWException("vw.api.SNumberofFieldNamesNotEqualNumberofFieldValues", "Number of field name must equal the number of field values.");
            }
            fields = new VWField[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                if (fieldNames[i] == null) {
                    throw new VWException("vw.api.SFieldNameIsNull", "Field name is null: element={0}", new Integer(i));
                }
                boolean isArray = false;
                if (fieldValues[i] != null) {
                    isArray = fieldValues[i].getClass().isArray();
                }
                fieldType = VWFieldType.getVWFieldType(fieldValues[i]);
                fields[i] = new VWField(fieldNames[i], 3, fieldValues[i], false, fieldType, isArray, null);
                Object fieldValue = VWFieldUtility.convertFieldValue(fieldValues[i], fieldType, fieldNames[i], isArray);
                fields[i].setValue(fieldValue, false);
            }
        }
        VWCreateLiveWOResult[] results = null;
        int servers = this.getAllServers().size();
        if (servers > 1) {
            throw NOT_IMPLEMENTED;
        }
        results = (VWCreateLiveWOResult[])this.command(22, new Object[]{new VWLogonHandle(), fields, workflowIdentifier, new Integer(numberToCreate)}, VWCreateLiveWOResult[].class, false);
        logger.exiting(this.m_className, m_method, "RESULTS=" + Logger.count(results));
        return results;
    }

    public VWWorkflowSignature getWorkflowSignature(String workflowIdentifier) throws VWException {
        String m_method = "getWorkflowSignature wfId=" + workflowIdentifier;
        logger.entering(this.m_className, m_method);
        VWWorkflowSignature result = (VWWorkflowSignature)this.command(23, new Object[]{new VWLogonHandle(), workflowIdentifier}, VWWorkflowSignature.class, false);
        logger.exiting(this.m_className, m_method, result);
        return result;
    }

    public String getFileFromServer(String fileName, int FileType) throws VWException {
        String m_method = "getFileFromServer fileName=" + fileName;
        logger.entering(this.m_className, m_method);
        String result = (String)this.command(267, new Object[]{new VWLogonHandle(), fileName, new Integer(FileType)}, String.class, false);
        logger.exiting(this.m_className, m_method, result);
        return result;
    }

    public Boolean getLimitApplicationFunctionalityFlag() throws VWException {
        String m_method = "getLimitApplicationFunctionalityFlag";
        logger.entering(this.m_className, m_method);
        Boolean result = (Boolean)this.command(268, new Object[]{new VWLogonHandle()}, Boolean.class, false);
        logger.exiting(this.m_className, m_method, result);
        return result;
    }

    public String getWorkClassXML(int workSpaceId, String workflowIdentifier, boolean bAuthorForm, boolean bConvert) throws VWException {
        String m_method = "getWorkClassXML wsId=" + workSpaceId + ", wfId=" + workflowIdentifier + ", authorForm=" + bAuthorForm + ", convert=" + bConvert;
        logger.entering(this.m_className, m_method);
        String results = (String)this.command(24, new Object[]{new VWLogonHandle(), new Integer(workSpaceId), workflowIdentifier, new Boolean(bAuthorForm), new Boolean(bConvert)}, String.class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public String getServerName() throws VWException {
        String m_method = "getServerName";
        logger.entering(this.m_className, m_method);
        IVWRouter router = this.getRouter();
        if (router == null) {
            throw new VWException("vw.server.VWCommandSessionCouldNotFindRouter", "Could not get Router.");
        }
        String result = null;
        try {
            result = router.getServiceURL();
        }
        catch (RemoteException re) {
            this.unpackRemoteException(re);
        }
        logger.exiting(this.m_className, m_method);
        return result;
    }

    public VWParticipant[] convertSecurityIdstoNames(Long[] ids) throws VWException {
        String m_method = "convertSecurityIdstoNames";
        logger.entering(this.m_className, m_method);
        VWParticipant[] results = (VWParticipant[])this.command(260, new Object[]{new VWLogonHandle(), ids}, VWParticipant[].class, false);
        logger.exiting(this.m_className, m_method, "RESULTS=" + Logger.asString(results));
        return results;
    }

    public Long[] convertSecurityNamestoIds(String[] names, boolean assignId) throws VWException {
        String m_method = "convertSecurityNamestoIds";
        logger.entering(this.m_className, m_method);
        Long[] results = (Long[])this.command(261, new Object[]{new VWLogonHandle(), names, new Boolean(assignId)}, Long[].class, false);
        logger.exiting(this.m_className, m_method, "RESULTS=" + Logger.asString(results));
        return results;
    }

    public int getSecurityType() {
        if (this.logonCreds != null) {
            return this.logonCreds.getSecurityType();
        }
        return 1;
    }

    public boolean isSecurityCaseSensitive() {
        if (this.logonCreds != null) {
            return this.logonCreds.getIsCaseSensitive();
        }
        return true;
    }

    public long getSecurityId() throws VWException {
        if (this.logonCreds != null) {
            return this.logonCreds.getSecurityId();
        }
        return 9L;
    }

    public String getDomain() {
        if (this.logonCreds != null) {
            return this.logonCreds.getDomain();
        }
        return null;
    }

    public String getDefaultDomain() throws VWException {
        if (this.logonCreds != null) {
            return this.logonCreds.getDefaultDomain();
        }
        return null;
    }

    public VWReturnStackElement[] getReturnStackElements(int viewId, int queryType, VWWorkObjectID workObjectId, boolean userBoundQuery) throws VWException {
        String m_method = "getReturnStackElements";
        logger.entering(this.m_className, m_method);
        StringBuffer buf = new StringBuffer();
        buf.append("QT:").append(queryType);
        logger.finest(this.m_className, m_method, buf.toString());
        VWReturnStackElement[] results = null;
        if (queryType != 2 && queryType != 1) {
            throw new VWException("vw.server.VWCommandSessiongetReturnStackElementsBadQType", "Bad Query Type{0}", new Integer(queryType).toString());
        }
        results = (VWReturnStackElement[])this.command(27, new Object[]{new VWLogonHandle(), new Integer(viewId), new Integer(queryType), workObjectId, new Boolean(userBoundQuery)}, VWReturnStackElement[].class, true);
        logger.exiting(this.m_className, m_method, " RESULTS=" + Logger.count(results));
        return results;
    }

    public VWEnvironmentDataQueryResults fetchUserEnvironmentRecords(int maxBufferSize, VWEnvironmentData startRecord, boolean throwException) throws VWException {
        String m_method = "fetchUserEnvironmentRecords";
        logger.entering(this.m_className, m_method);
        StringBuffer buf = new StringBuffer();
        buf.append("buffer:").append(maxBufferSize);
        buf.append(", startRecord:").append(Logger.asString(startRecord));
        buf.append(", throwException:").append(throwException);
        logger.finest(this.m_className, m_method, buf.toString());
        VWEnvironmentDataQueryResults results = null;
        results = (VWEnvironmentDataQueryResults)this.command(209, new Object[]{new VWLogonHandle(), new Integer(maxBufferSize), startRecord, new Boolean(throwException)}, VWEnvironmentDataQueryResults.class, false);
        logger.exiting(this.m_className, m_method, " RESULTS=" + Logger.count(results));
        return results;
    }

    public VWSecurityDomain[] fetchSecurityDomains() throws VWException {
        String m_method = "fetchSecurityDomains";
        logger.entering(this.m_className, m_method);
        VWSecurityDomain[] results = null;
        results = (VWSecurityDomain[])this.command(265, new Object[]{new VWLogonHandle()}, VWSecurityDomain[].class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public VWParticipant[] fetchParticipants(String domainName, String[] theUserNameList, long rpcArgFlag) throws VWException {
        String m_method = "fetchParticipants";
        logger.entering(this.m_className, m_method);
        VWParticipant[] results = null;
        results = (VWParticipant[])this.command(266, new Object[]{new VWLogonHandle(), domainName, theUserNameList, new Long(rpcArgFlag)}, VWParticipant[].class, false);
        logger.exiting(this.m_className, m_method);
        return results;
    }

    public VWWorkflowSignature[] getMultipleWorkflowSignatures(int flags) throws VWException {
        throw new VWException("vw.server.VWCommandSessionNewRPCNotImplementedInOldCode", "RPC not implemented in the Java version of PE, use the ORB PE server in P8 4.0 or later.");
    }

    public VWTransferResult transferWorkflowCollection(String wfCollectionStr, String theWFDocKey, boolean theLinked, boolean theMakeNewWorkSpace) throws VWException {
        throw new VWException("vw.server.VWCommandSessionNewRPCNotImplementedInOldCode", "RPC not implemented in the Java version of PE, use the ORB PE server in P8 4.0 or later.");
    }

    private VWLogonCredentials decodeToken(String token) throws VWException {
        if (token == null) {
            throw new VWException("vw.server.VWCommandSessionInvalidToken", "Token is invalid.");
        }
        VWLogonCredentials cred = null;
        VWCapsule c = new VWCapsule();
        c.setString(token);
        cred = (VWLogonCredentials)VWSOAPUtils.base64ObjectDeserializer(c.getString());
        if (cred == null) {
            throw new VWException("vw.server.VWCommandSessionInvalidToken", "Token is invalid.");
        }
        return cred;
    }

    private String encodeToken() throws VWException {
        String s = VWSOAPUtils.base64ObjectSerializer(this.logonCreds);
        VWCapsule c = new VWCapsule(s);
        return c.getStr();
    }

    private boolean isSOAPRouterURL(String theRouterURL) {
        try {
            new VWSOAPRouterURL(theRouterURL);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public void ping() throws VWException {
    }

    public IPECommands getIPECommandsForDest(String dest) throws VWException {
        VWCommandSession serverCmdSession = this.findSession(dest);
        if (serverCmdSession == null) {
            serverCmdSession = new VWCommandSession(this, dest);
        }
        return serverCmdSession;
    }

    public String getConnectionPointName() throws VWException {
        return this.theRouterURL;
    }

    public VWConfigInfo[] getWorkClassIdConfig() throws VWException {
        return null;
    }

    public String translate(String inStr) throws VWException {
        return inStr;
    }

    public String translateToAuthored(String inStr) throws VWException {
        return inStr;
    }

    public void setClientLocale(Locale myLocale) throws VWException {
    }

    public Locale getClientLocale() throws VWException {
        return null;
    }

    public String[] getAvailableLocales() throws VWException {
        return null;
    }

    public String getServerLocale() throws VWException {
        return null;
    }

    public VWParticipantList fetchRoleParticipants(String roleName, String appSpaceName) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public VWParticipantList fetchRoleParticipantsEx(String roleName, String appSpaceName, boolean isRuntimeCaller) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public VWRole fetchMyRole(String roleName, String appSpaceName) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public VWRole[] fetchMyRoles(String shortName, String appSpaceName) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public String[] fetchMemberOf(String userName) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public InternalVWWorkBasket[] fetchMyWorkBaskets(String roleName, String appSpaceName) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public InternalVWWorkBasket fetchMyWorkBasket(String roleName, String appSpaceName, int queueClassId, String workBasketName) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public InternalVWWorkBasket[] fetchWorkBasketsForQueue(int queueClassId, String[] workBasketNames) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public int fetchPrivileges() throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public Boolean verifyDBConnection(VWDBExecuteConnection dbConnection) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public String[] fetchRoleNames(int accessLevel, String orbInAppSpaceName) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public VWRole[] fetchRoles(String orbInAppSpaceName, String[] orbInRoleNames) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public String[] fetchAppSpaceNames(boolean ignoreSecurity) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public VWParticipantList setRolePartipants(String orbInAppSpaceName, String orbInRoleName, String[] addParticipantNames, String[] removeParticipantNames) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public VWField[] createLaunchStepElement(String[] fieldNames, Object[] fieldValues, String workflowIdentifier, int i, boolean returnWobNum) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public VWApplicationSpace[] fetchApplicationSpaces(String[] orbInAppSpaceNames, int orbInFilterFlag) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public CEObjectInfo fetchCEObjectInfo(VWGuid objectStoreId, VWGuid classId, VWGuid objectId) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public String fetchObjectStoreSymbolicName(VWGuid objectStoreId) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public VWGuid fetchObjectStoreId(String objectStoreSymbolicName) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public boolean verifyCreds() throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public VWGuid getObjectStoreId() throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    public CEObjectInfo fetchCEObjectInfoByName(VWGuid objectStoreId, String symbolicName) throws VWException {
        throw new VWException("orb.session.NotImplemented", "Not Implemented Yet");
    }

    static {
        try {
            RPC_TIMEOUT = Long.parseLong(System.getProperty(RPC_TIMEOUT_PROPERTY));
        }
        catch (Throwable e) {
            RPC_TIMEOUT = 18000L;
        }
    }
}

